/*==============================================================================
HSNotify.

Harassment 101 Replication Spawnnotify.
==============================================================================*/
class HSNotify expands SpawnNotify;

var color HeadshotColor, TauntColor, PerfectColor;
var string HeadshotMessage[25];
var string PerfectMessage[25];
var string TauntMessage[10];
var string ClanTag;

simulated function PreBeginPlay()
{
	bAlwaysRelevant = True;
}

simulated event Actor SpawnNotification(actor A)
{
	local HSReplication HRep;
	local int i;

	if (A.IsA('Pawn') && !A.IsA('Bot') && !A.IsA('Spectator') )
	{
		HRep = Spawn(Class'HSReplication', Pawn(A).PlayerReplicationInfo,, A.Location);
		HRep.ClanTag = ClanTag;
		HRep.HeadShotColor = HeadShotColor;
		HRep.PerfectColor = PerfectColor;
		HRep.TauntColor = TauntColor;

		for(i=0; i<arraycount(HeadshotMessage);i++)
		{
			if (HeadshotMessage[i] != "" )
				HRep.HeadshotMessage[i] = HeadshotMessage[i];
			else break;
		}
		for(i=0; i<arraycount(PerfectMessage);i++)
		{
			if (PerfectMessage[i] != "" )
				HRep.PerfectMessage[i] = PerfectMessage[i];
			else break;
		}
		for(i=0; i<arraycount(TauntMessage);i++)
		{
			if ( TauntMessage[i] != "" )
				HRep.TauntMessage[i] = TauntMessage[i];
			else break;
		}
	}
	return A;
}
defaultproperties
{
	ActorClass=Class'Engine.Pawn'
	RemoteRole=ROLE_SimulatedProxy
}
